# -*- coding: utf-8 -*-
"""
Created on Sat Aug  3 13:13:51 2019

@author: tooba
"""

from keras.layers import Dense, Dropout, Flatten, Embedding
import numpy as np
import pandas as pd
import socket
import struct
from keras.layers import GRU
from sklearn.model_selection import train_test_split
from numpy import array
from numpy import argmax
from keras.utils import to_categorical
from keras.models import Sequential
from keras.layers import Dense, Activation
from sklearn.metrics import accuracy_score
from sklearn.datasets import load_iris
from sklearn import preprocessing
from mlxtend.evaluate import confusion_matrix
from keras.models import Model # basic class for specifying and training a neural network
from keras.layers import Input, Convolution2D, MaxPooling2D, Dense, Dropout, Activation, Flatten
from keras.utils import np_utils # utilities for one-hot encoding of ground truth values
from sklearn.metrics import  classification_report
import itertools
import keras
from IPython.display import clear_output
from sklearn.metrics import roc_curve, auc
from sklearn.preprocessing import MinMaxScaler
import matplotlib.pyplot as plt
from sklearn.preprocessing import StandardScaler
import datetime
from numpy import argmax
from sklearn.preprocessing import label_binarize
from scipy import interp
from itertools import cycle
from sklearn.preprocessing import MinMaxScaler

#Confusion Matrix
def plot_confusion_matrix(cm, classes,
                          normalize=False,
                          title='Confusion matrix',
                          cmap=plt.cm.Greens):
    """
    This function prints and plots the confusion matrix.
    Normalization can be applied by setting `normalize=True`.
    """
    if normalize:
        cm = cm.astype('float') / cm.sum(axis=1)[:, np.newaxis]
        print("Normalized confusion matrix")
    else:
        print('Confusion matrix, without normalization')

    print(cm)
    
    plt.figure(figsize=(5,5))
    plt.imshow(cm, interpolation='nearest', cmap=cmap)    
    plt.title(title)
    plt.colorbar()
    tick_marks = np.arange(len(classes))
    plt.xticks(tick_marks, classes, rotation=45)
    plt.yticks(tick_marks, classes)

    fmt = '.2f' if normalize else 'd'
    thresh = cm.max() / 2.
    for i, j in itertools.product(range(cm.shape[0]), range(cm.shape[1])):
        plt.text(j, i, format(cm[i, j], fmt),
                 horizontalalignment="center",
                 color="white" if cm[i, j] > thresh else "black")

    plt.tight_layout()
    plt.ylabel('True label')
    plt.xlabel('Predicted label')
    plt.savefig('DNN.jpeg')


#import training data
dynamic_classes = 3
dataset = pd.read_csv('Book1.csv')
dataset = dataset.sample(frac=1).reset_index(drop=True)


#split dataset
X = dataset.iloc[:,:115]
Y = dataset.iloc[:,116:117]

#from sklearn import preprocessing

min_max_scaler = preprocessing.MinMaxScaler()
X = min_max_scaler.fit_transform(X)


#Slicing
x_train, x_test, y_train, y_test = train_test_split (X,Y, test_size=0.2)


#OHE
y_train = to_categorical(y_train, dynamic_classes)
y_train= pd.DataFrame(y_train)

x_train = np.array(x_train)
x_test = np.array(x_test)
x_train = np.reshape(x_train, (x_train.shape[0], 1, x_train.shape[1]))
x_test = np.reshape(x_test, (x_test.shape[0], 1,  x_test.shape[1])) 


#MODEL GRU
classifier = Sequential()
classifier.add(GRU(450, activation='relu', input_shape = (x_train.shape[1],x_train.shape[2]), return_sequences=True)) 
classifier.add(GRU(400, activation='relu', return_sequences=True))
classifier.add(GRU(350, activation='relu', return_sequences=False))
classifier.add(Dropout(0.1))
classifier.add(Dense(units = 3, kernel_initializer = 'uniform', activation = 'softmax'))
classifier.summary()
classifier.compile(optimizer = 'adam', loss = 'categorical_crossentropy', metrics = ['accuracy'])
classifier.fit(x_train, y_train, batch_size =4 , epochs = 5)
classifier.save("GRU")

#prediction
predictions = classifier.predict(x_test)
predictions = np.round(predictions)
#predictions = pd.DataFrame(predictions)

#Invering OHE
# predictions = np.array(predictions)
pred_gru = predictions.argmax(1)
pred_gru = pd.DataFrame(pred_gru)

#Accuracy
print ("Accuracy:  ", accuracy_score(y_test,pred_gru)*100)



#Classificaiton report
print("Classification Report")
print(classification_report(y_test,pred_gru))



#Calculating Confusion Matix for 3D
class_names = ['Benign','Mirai', 'Gafgyt']
cm_cnn = confusion_matrix(y_test, pred_gru, binary=False)
plt.figure()
plot_confusion_matrix(cm_cnn, classes=class_names , normalize=False,
                      title='Confusion matrix, without normalization')



#TP FP
#FN TN
print(cm_cnn)
cm_cnn = np.array(cm_cnn)
TP = cm_cnn[0][0]
#FP = np.int(np.sum(cm_cnn[np.triu_indices(num_classes,1,num_classes)]))
FP =  np.triu(cm_cnn).sum()-np.trace(cm_cnn)
# cm[row][column]
FN = np.tril(cm_cnn).sum()-np.trace(cm_cnn)
print()
TN = np.trace(cm_cnn) - TP

#Calculating Other Parameters
print('TP:{}'.format(TP))
print('FP:{}'.format(FP))
print('FN:{}'.format(FN))
print('TN:{}'.format(TN))
print('TPR: {}'.format(TP/(TP + FN)))
print('TNR: {}'.format(TN/(TN + FP)))
print('PPV: {}'.format(TP/(TP + FP)))
print('NPV: {}'.format(TN/(TN + FN)))
print('FNR: {}'.format(FN/(FN + TP)))
print('FPR: {}'.format(FP/(FP + TN)))
print('FDR: {}'.format(FP/(FP + TP)))
print('FOR: {}'.format(FN/(FN + TN)))

TP
from sklearn.metrics import matthews_corrcoef
MCC = matthews_corrcoef(y_test, pred_gru) 
print('MCC: {}'.format(MCC))


#To be Executed once--------------------------------------------------------
from scipy import interp
from itertools import cycle
# Compute ROC curve and ROC area for each class
fpr = dict()
tpr = dict()
roc_auc = dict()
y_test_cnn = to_categorical(y_test, 3)
y_test_cnn = np.array(y_test_cnn)
n_classes = 3
pred_cnnictions_cnn = np.array(predictions)
lw=2
#---------------------------------------------------------------------------


for i in range(n_classes):
    fpr[i], tpr[i], _ = roc_curve(y_test_cnn[:, i], pred_cnnictions_cnn[:, i])
    roc_auc[i] = auc(fpr[i], tpr[i])

# Compute micro-average ROC curve and ROC area
fpr["micro"], tpr["micro"], _ = roc_curve(y_test_cnn.ravel(), pred_cnnictions_cnn.ravel())
roc_auc["micro"] = auc(fpr["micro"], tpr["micro"])


# Compute macro-average ROC curve and ROC area
# First aggregate all false positive rates
all_fpr = np.unique(np.concatenate([fpr[i] for i in range(n_classes)]))

# Then interpolate all ROC curves at this points
mean_tpr = np.zeros_like(all_fpr)
for i in range(n_classes):
    mean_tpr += interp(all_fpr, fpr[i], tpr[i])

# Finally average it and compute AUC
mean_tpr /= n_classes

fpr["macro"] = all_fpr
tpr["macro"] = mean_tpr
roc_auc["macro"] = auc(fpr["macro"], tpr["macro"])

# Plot all ROC curves
plt.figure()
plt.figure(figsize=(5,5))

plt.plot(fpr["micro"], tpr["micro"],
         label='Ideal Performance-AUC = {0:0.2f}'
               ''.format(roc_auc["micro"]),
         color='orange', linestyle=':', linewidth=4)

plt.plot(fpr["macro"], tpr["macro"],
         label='Grand Average of All CLasses-AUC = {0:0.2f}'
               ''.format(roc_auc["macro"]),
         color='green', linestyle=':', linewidth=4)

colors = cycle(['olive', 'red', 'gray', 'lightgreen', 'coral', 'tan', 'yellowgreen', 'lightblue', 'coral'])
cls = {'Normal','FTP','SSH'}
for i, color in zip(range(n_classes), colors):
    plt.plot(fpr[i], tpr[i], color=color, lw=lw,
             label='ROC curve of class {0} AUC = {1:0.2f}'''.format(i, roc_auc[i]))
8
plt.plot([0, 1], [0, 1], 'k--', lw=lw)
plt.xlim([0, 1.0])
plt.ylim([0, 1.05])
plt.xlabel('False Positive Rate')
plt.ylabel('True Positive Rate')
plt.title('ROC')
plt.legend(loc="lower right")
plt.savefig("DNN ROC")
plt.show()
